/**
 * 
 */
/**
 * @author Janet Lopez
 *
 */
package gov.va.genisis2.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.List;

import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.common.enums.RefreshStatusEnum;
import gov.va.genisis2.converter.UserRefreshHistoryConverter;
import gov.va.genisis2.dao.IUserManagementDao;
import gov.va.genisis2.dao.impl.UserManagementDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.User;
import gov.va.genisis2.model.UserCount;
import gov.va.genisis2.model.UserRefreshHistory;
import gov.va.genisis2.service.IUserManagementService;
import gov.va.genisis2.util.Helper;

/**
 * The Class UserManagementServiceTest.
 *
 * @author Getaneh Kassahun
 * 
 *         The Class UserManagementServiceTest.
 * 
 *         Description: In this UserManagementServiceTest Class which extends
 *         the abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class UserManagementServiceTest extends AbstractMockMvcTests {

	/** The LOGGER. */
	private static final Logger logger = LoggerFactory.getLogger(UserManagementServiceTest.class);

	/** The userManagementService. */
	@Autowired
	private IUserManagementService userManagementServiceAutowired;

	/** The userManagementDao. */
	@Autowired
	private IUserManagementDao userManagementDao;
	
	@Autowired
	private UserRefreshHistoryConverter userRefreshHistoryConverter;

	private UserManagementService userManagementService;

	private UserManagementDao userManagementDao_SF_Null;

	/** The users. */
	private User users;

	/**
	 * Test get user details by email.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetUserDetailsByEmail_1() throws GenisisServiceException {

		logger.info("**********Junit Get User Details By Email**********");
		users = userManagementServiceAutowired.getUserDetailsByEmail("genisisad@gmail.com");
		assertNotNull(users);

	}

	/**
	 * Test get user details by email.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetUserDetailsByEmail_2() throws GenisisServiceException {

		logger.info("**********Junit test GetUserDetailsByEmail with null SessionFactory**********");
		setSessionFactory_Null();
		userManagementService.getUserDetailsByEmail("");

	}

	/**
	 * Test get User Details By Id.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetUserDetailsById_1() throws GenisisServiceException {

		logger.info("**********Junit Get User Details By Id**********");
		users = userManagementServiceAutowired.getUserDetailsById(1);
		assertNotNull(users);

	}

	/**
	 * Test get User Details By Id.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetUserDetailsById_2() throws GenisisServiceException {

		logger.info("**********Junit Get User Details By Id with null SessionFactory**********");
		setSessionFactory_Null();
		userManagementService.getUserDetailsById(1);

	}

	/**
	 * Test get User Role.
	 * 
	 * @throws GenisisServiceException
	 */

	@Test
	public void testGetUserRole_1() throws GenisisDAOException, GenisisServiceException {

		logger.info("**********Junit Get  User Role**********");
		users = userManagementDao.getUserDetailsById(1);
		String userRole = userManagementServiceAutowired.getUserRole(users.getUserId());
		assertNotNull(userRole);

	}

	/**
	 * Test get User Role.
	 * 
	 * @throws GenisisServiceException
	 */

	@Test(expected = GenisisServiceException.class)
	public void testGetUserRole_2() throws GenisisServiceException {

		logger.info("**********Junit Get  User Role with null SessionFactory**********");
		setSessionFactory_Null();
		userManagementService.getUserRole(1);

	}

	/**
	 * Test get UserDetailsByUsername.
	 * 
	 * @throws GenisisServiceException
	 */

	@Test
	public void testGetUserDetailsByUsername_1() throws GenisisServiceException {

		logger.info("**********Junit Get UserDetailsByUsername**********");
		users = userManagementServiceAutowired.getUserDetailsByUsername("DNS   DNS");
		assertEquals("DNS   DNS", users.getUsername());

	}

	/**
	 * Test get UserDetailsByUsername.
	 * 
	 * @throws GenisisServiceException
	 */

	@Test(expected = GenisisServiceException.class)
	public void testGetUserDetailsByUsername_2() throws GenisisServiceException {

		logger.info("**********Junit Get UserDetailsByUsername with null SessionFactory**********");
		setSessionFactory_Null();
		userManagementService.getUserDetailsByUsername("DNS   FRANCISS");

	}

	/**
	 * Test getUserCountOnRole.
	 * 
	 * @throws GenisisServiceException
	 */

	@Test
	public void testGetUserCountOnRole_1() throws GenisisServiceException {

		logger.info("**********Junit test Get UserCountOnRole**********");
		List<UserCount> listUserCount = userManagementServiceAutowired.getUserCountOnRole();
		assertNotNull(listUserCount);

	}

	/**
	 * Test getUserCountOnRole.
	 * 
	 * @throws GenisisServiceException
	 */

	@Test(expected = GenisisServiceException.class)
	public void testGetUserCountOnRole_2() throws GenisisServiceException {

		logger.info("**********Junit test Get UserCountOnRolewith null SessionFactory**********");
		setSessionFactory_Null();
		userManagementService.getUserCountOnRole();

	}

	/**
	 * Test createUserRefreshHistory.
	 * 
	 * @throws GenisisServiceException
	 * 
	 */

	@Test
	public void testCreateUpdateUserRefreshHistory_1() throws GenisisServiceException {

		logger.info("**********Junit test reateUserRefreshHistory**********");
		UserRefreshHistory userRefreshHistory = userRefreshHistoryConverter.populateUserRefreshHistory("test");
		int id = userManagementServiceAutowired.createUserRefreshHistory(userRefreshHistory);
		assertTrue(id > 0);
		
		userRefreshHistory.setId(id);
		userRefreshHistoryConverter.populateUserRefreshHistory(userRefreshHistory);
		UserRefreshHistory updatedUserRefreshHistory = userManagementServiceAutowired.updateUserRefreshHistory(userRefreshHistory);
		assertEquals(RefreshStatusEnum.COMPLETED.getDesc(), updatedUserRefreshHistory.getStatus());
		
		Date date = userManagementServiceAutowired.getLatestUserRefreshHistory();
		assertNotNull(date);
	}

	/**
	 * Test createUserRefreshHistory.
	 * 
	 * @throws GenisisServiceException
	 * 
	 */

	@Test(expected = GenisisServiceException.class)
	public void testCreateUserRefreshHistory_2() throws GenisisServiceException {

		logger.info("**********Junit test reateUserRefreshHistory with null SessionFactory**********");
		setSessionFactory_Null();
		userManagementService.createUserRefreshHistory(Helper.getUserRefreshHistory());

	}
	
	/**
	 * Test getLatestUserRefreshHistory.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetLatestUserRefreshHistory_2() throws GenisisServiceException {

		logger.info("**********Junit test Get LatestUserRefreshHistory with null SessionFactory**********");
		setSessionFactory_Null();
		userManagementService.getLatestUserRefreshHistory();

	}

	/**
	 * Test createUserRefreshHistory.
	 * 
	 * @throws GenisisServiceException
	 * 
	 */

	/*
	 * @Test public void testUpdateUserRefreshHistory() throws
	 * GenisisServiceException {
	 * 
	 * logger.info("**********Junit test reateUserRefreshHistory**********");
	 * userRefreshHistory =
	 * userManagementService.updateUserRefreshHistory(Helper.
	 * getUserRefreshHistory()); assertNotNull(userRefreshHistory);
	 * 
	 * }
	 */

	/**
	 * Test createUserRefreshHistory.
	 * 
	 * @throws GenisisServiceException
	 * 
	 */

	@Test(expected = GenisisServiceException.class)
	public void testUpdateUserRefreshHistory_2() throws GenisisServiceException {

		logger.info("**********Junit test reateUserRefreshHistory**********");
		setSessionFactory_Null();
		userManagementService.updateUserRefreshHistory(null);

	}

	private void setSessionFactory_Null() {
		userManagementService = new UserManagementService();
		userManagementDao_SF_Null = new UserManagementDao();
		userManagementDao_SF_Null.setSessionFactory(null);
		userManagementService.setUserManagementDao(userManagementDao_SF_Null);
	}

}
